﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;

namespace Inet.Viewer.WinForms.Export
{
    /// <summary>
    /// Settings panel for CSV (comma separated vector) exports. The user can set
    /// various options for delimiters, columns and encoding.
    /// </summary>
    public partial class CSVSettingsControl : FormatSettingsControl
    {
        private const string SUFFIX = "csv";

        private const string PropDelimiter = "delimiter";
        private const string PropQuoteChar = "quotechar";
        private const string PropEncoding = "encoding";
        private const string PropColsWidth = "colswidth";
        private const string PropDataColumnNames = "columnnames";

        /// <summary>
        /// Creates the control instance.
        /// </summary>
        public CSVSettingsControl()
        {
            InitializeComponent();
        }

        /// <inheritdoc />
        public override Bitmap Icon { get { return FormatResource.csv_48; } }

        /// <inheritdoc />
        public override string Label { get { return "CSV"; } }

        /// <inheritdoc />
        public override string FileSuffix { get { return SUFFIX; } }

        /// <inheritdoc />
        public override void CollectExportParameters(Dictionary<string, string> exportParams)
        {
            if (rbDelimiterOther.Checked)
            {
                exportParams[PropDelimiter] = tbOtherDelimiter.Text;
            }
            else if (rbFixedWidths.Checked)
            {
                exportParams[PropColsWidth] = tbFixedWidths.Text;
            }
            else
            {
                exportParams[PropDelimiter] = Controls.OfType<RadioButton>().FirstOrDefault(r => r.Checked).Tag.ToString();
            }

            if (!rbFixedWidths.Checked)
            {
                exportParams[PropQuoteChar] = tbTextQualifier.Text;
            }

            exportParams[PropEncoding] = cmbCodepage.Text;

            if (chbDataOnly.Checked)
            {
                exportParams[URLRenderData.ParameterExportFmt] = ReportInfo.FormatData;
                exportParams[PropDataColumnNames] = chbDataOnlyWithColNames.Checked ? URLRenderData.ValueTrue : URLRenderData.ValueFalse;
            }
            else
            {
                exportParams[URLRenderData.ParameterExportFmt] = ReportInfo.FormatCSV;
            }
        }

        /// <summary>
        /// Called when a delimiter radio button state was changed. Enables/disables
        /// the corresponding fields.
        /// </summary>
        /// <param name="sender">the sender</param>
        /// <param name="e">the arguments of the event</param>
        private void rbColumnDelimiter_Changed(object sender, EventArgs e)
        {
            if (rbDelimiterOther.Checked)
            {
                tbOtherDelimiter.Enabled = true;
                tbFixedWidths.Enabled = false;
            }
            else if (rbFixedWidths.Checked)
            {
                tbOtherDelimiter.Enabled = false;
                tbFixedWidths.Enabled = true;
            }
            else
            {
                tbOtherDelimiter.Enabled = false;
                tbFixedWidths.Enabled = false;
            }
        }

        /// <summary>
        /// Called when the "data only" checkbox state was changed. Enables/disables
        /// the corresponding "with column name" checkbox.
        /// </summary>
        /// <param name="sender">the sender</param>
        /// <param name="e">the arguments of the event</param>
        private void chbDataOnly_CheckedChanged(object sender, EventArgs e)
        {
            chbDataOnlyWithColNames.Enabled = chbDataOnly.Checked;
        }
    }
}
